package io.agora.avc.push

import com.agora.valoran.bean.IncomingData
import com.google.gson.JsonObject
import io.agora.avc.dao.AppDatabase
import io.agora.avc.net.api.ApiService
import io.agora.avc.net.bean.BaseNo
import io.agora.avc.po.IncomingRecord
import io.agora.avc.utils.TimeUtils2
import io.agora.frame.data.IDataRepository
import io.reactivex.Observable
import javax.inject.Inject

class PushDataRepositoryImpl @Inject constructor(
    private val dataRepository: IDataRepository,
) : PushDataRepository {

    private val roomDatabase by lazy {
        dataRepository.getRoomDatabase(AppDatabase::class.java, AppDatabase.DB_NAME)
    }

    override fun reportToken(token: String, platform: String, channel: String): Observable<BaseNo> {
        val jsonObject = JsonObject()
        jsonObject.addProperty("deviceToken", token)
        jsonObject.addProperty("platform", platform)
        jsonObject.addProperty("channel", channel)
        return dataRepository.getRetrofitService(ApiService::class.java)
            .reportToken(jsonObject)
    }

    override fun queryIncomingRecord(requestId: String): IncomingRecord? {
        return roomDatabase.incomingRecordDao().getRecord(requestId)
    }

    override fun saveIncomingRecord(incomingData: IncomingData): Long {
        return roomDatabase.incomingRecordDao().insert(
            IncomingRecord(
                incomingData.rid,
                incomingData.pwd,
                incomingData.ticket,
                incomingData.requestId,
                incomingData.inviterName,
                incomingData.inviterAvatar,
                timestamp = TimeUtils2.getNowMills()
            )
        )
    }

    companion object {
        private const val TAG = "[COMM][PushDataRepository]"
    }
}