package io.agora.avc.push.fcm

import com.agora.valoran.bean.IncomingData
import io.agora.avc.biz.event.AppEventBus
import io.agora.avc.manager.media.MediaPlayer
import io.agora.avc.manager.upgrade.AppUpgradeManager
import io.agora.avc.net.BaseObserver
import io.agora.avc.net.bean.BaseNo
import io.agora.avc.push.BasePushManager
import io.agora.avc.push.PushDataRepository
import io.agora.logger.Logger
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers
import java.util.*

class FcmPushManagerImpl(
    private val dataRepository: PushDataRepository,
    private val appEventBus: AppEventBus,
    private val mediaPlayer: MediaPlayer,
    private val appUpgradeManager: AppUpgradeManager,
) : BasePushManager(dataRepository, appEventBus, mediaPlayer, appUpgradeManager) {
    override fun doIncomingNew(incomingData: IncomingData) {

    }

    override fun getToken() {
//        FirebaseMessaging.getInstance().token.addOnCompleteListener(OnCompleteListener { task ->
//            if (!task.isSuccessful) {
//                Logger.e(TAG, "Fetching FCM registration token failed, exception:${task.exception}")
//                return@OnCompleteListener
//            }
//            // Get new FCM registration token
//            Logger.i(TAG, "token:${task.result}")
//            sendRegTokenToServer(task.result.toString())
//        })
    }

    override fun deleteToken() {
//        FirebaseMessaging.getInstance().deleteToken()
    }

    override fun sendRegTokenToServer(token: String) {
        dataRepository.reportToken(token, "android", CHANNEL)
            .subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe(object : BaseObserver<BaseNo>() {
                override fun onSuccess(t: BaseNo?) {
                    Logger.i(TAG, "successfully to report token")
                }

                override fun onFail(t: BaseNo?) {
                    Logger.e(TAG, "failed to report token")
                }
            })

    }

    companion object {
        private const val TAG = "FcmPushManagerImpl"
        private const val CHANNEL = "google"
    }
}