package io.agora.avc.push.hms

import com.agora.valoran.bean.IncomingData
import io.agora.avc.biz.event.AppEventBus
import io.agora.avc.manager.media.MediaPlayer
import io.agora.avc.manager.upgrade.AppUpgradeManager
import io.agora.avc.net.BaseObserver
import io.agora.avc.net.bean.BaseNo
import io.agora.avc.push.BasePushManager
import io.agora.avc.push.PushDataRepository
import io.agora.logger.Logger
import io.reactivex.Observable
import io.reactivex.Observer
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.disposables.Disposable
import io.reactivex.schedulers.Schedulers

class HmsPushManagerImpl(
    private val dataRepository: PushDataRepository,
    private val appEventBus: AppEventBus,
    private val mediaPlayer: MediaPlayer,
    private val appUpgradeManager: AppUpgradeManager,
) : BasePushManager(dataRepository, appEventBus, mediaPlayer, appUpgradeManager) {
    override fun doIncomingNew(incomingData: IncomingData) {

    }

    override fun getToken() {
//        Observable
//            .create<String> {
//                var token = ""
//                try {
//                    val appId = APP_ID
//                    val tokenScope = TOKEN_SCOPE
//                    token = HmsInstanceId.getInstance(getContext()).getToken(appId, tokenScope)
//                } catch (e: ApiException) {
//                    Logger.e(TAG, "get token failed, $e")
//                }
//                Logger.i(TAG, "get token:$token")
//                if (!token.isNullOrEmpty()) {
//                    it.onNext(token)
//                } else {
//                    it.onError(throw IllegalArgumentException("can not get token"))
//                }
//            }
//            .flatMap { token ->
//                reportTokenObservable(token)
//            }
//            .subscribeOn(Schedulers.io())
//            .observeOn(AndroidSchedulers.mainThread())
//            .subscribe(object : Observer<BaseNo> {
//                override fun onSubscribe(d: Disposable) {
//                }
//
//                override fun onNext(t: BaseNo) {
//                    Logger.i(TAG, "successfully to report token")
//                }
//
//                override fun onError(e: Throwable) {
//                    Logger.e(TAG, "failed to report token", e)
//                }
//
//                override fun onComplete() {
//                }
//
//            })
    }

    override fun deleteToken() {
//        Observable
//            .create<String> {
//                try {
//                    val appId = APP_ID
//                    val tokenScope = TOKEN_SCOPE
//                    HmsInstanceId.getInstance(getContext()).deleteToken(appId, tokenScope)
//                    Logger.i(TAG, "token deleted successfully")
//                } catch (e: ApiException) {
//                    Logger.e(TAG, "delete token failed, $e")
//                }
//                it.onNext("")
//            }
//            .subscribeOn(Schedulers.io())
//            .observeOn(AndroidSchedulers.mainThread())
//            .subscribe(object : Observer<String> {
//                override fun onSubscribe(d: Disposable) {
//                }
//
//                override fun onNext(t: String) {
//
//                }
//
//                override fun onError(e: Throwable) {
//
//                }
//
//                override fun onComplete() {
//                }
//
//            })
    }

    override fun sendRegTokenToServer(token: String) {
        Logger.i(TAG, "sending token to server. token:$token")
        reportTokenObservable(token)
            .subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe(object : BaseObserver<BaseNo>() {
                override fun onSuccess(t: BaseNo?) {
                    Logger.i(TAG, "successfully to report token")
                }

                override fun onFail(t: BaseNo?) {
                    Logger.e(TAG, "failed to report token")
                }
            })
    }

    private fun reportTokenObservable(token: String) =
        dataRepository.reportToken(token, "android", CHANNEL)

    companion object {
        private const val TAG = "HmsPushManagerImpl"
        private const val APP_ID = "101383969"
        private const val TOKEN_SCOPE = "HCM"
        private const val CHANNEL = "huawei"
    }
}