package io.agora.avc.push.xiaomi

import android.app.Application
import com.agora.valoran.bean.IncomingData
import com.xiaomi.mipush.sdk.MiPushClient
import io.agora.avc.MyApplication
import io.agora.avc.biz.event.AppEventBus
import io.agora.avc.manager.media.MediaPlayer
import io.agora.avc.manager.upgrade.AppUpgradeManager
import io.agora.avc.net.BaseObserver
import io.agora.avc.net.bean.BaseNo
import io.agora.avc.push.BasePushManager
import io.agora.avc.push.PushDataRepository
import io.agora.logger.Logger
import io.reactivex.Observable
import io.reactivex.Observer
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.disposables.Disposable
import io.reactivex.schedulers.Schedulers


class MiPushManagerImpl(
    private val application: Application,
    private val dataRepository: PushDataRepository,
    private val appEventBus: AppEventBus,
    private val mediaPlayer: MediaPlayer,
    private val appUpgradeManager: AppUpgradeManager,
) : BasePushManager(dataRepository, appEventBus, mediaPlayer, appUpgradeManager) {

    override fun doIncomingNew(incomingData: IncomingData) {

    }

    /**
     * get mi push token
     */
    override fun getToken() {
        Observable
            .create<String> {
                if (MyApplication.isMainProcess) {
                    Logger.i(TAG, "register mi push")
                    MiPushClient.registerPush(application, APP_ID, APP_KEY)
                }
                it.onNext("")
            }
            .subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe(object : Observer<String> {
                override fun onSubscribe(d: Disposable) {
                }

                override fun onNext(t: String) {
                    Logger.i(TAG, "start to get token")
                }

                override fun onError(e: Throwable) {
                    Logger.e(TAG, "failed to get token", e)
                }

                override fun onComplete() {
                }

            })
    }

    override fun deleteToken() {
        Observable
            .create<String> {
                if (MyApplication.isMainProcess) {
                    Logger.i(TAG, "unregister mi push")
                    MiPushClient.unregisterPush(application)
                }
                it.onNext("")
            }
            .subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe(object : Observer<String> {
                override fun onSubscribe(d: Disposable) {
                }

                override fun onNext(t: String) {
                    Logger.i(TAG, "successfully to call unregister token api")
                }

                override fun onError(e: Throwable) {
                    Logger.e(TAG, "failed to call unregister token api", e)
                }

                override fun onComplete() {
                }
            })
    }

    override fun sendRegTokenToServer(token: String) {
        Logger.i(TAG, "sending token to server. token:$token")
        reportTokenObservable(token)
            .subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe(object : BaseObserver<BaseNo>() {
                override fun onSuccess(t: BaseNo?) {
                    Logger.i(TAG, "successfully to report token")
                }

                override fun onFail(t: BaseNo?) {
                    Logger.e(TAG, "failed to report token")
                }
            })
    }

    private fun reportTokenObservable(token: String) =
        dataRepository.reportToken(token, "android", CHANNEL)

    companion object {
        private const val TAG = "MiPushManagerImpl"
        private const val APP_ID = "2882303761517703264"
        private const val APP_KEY = "5811770316264"
        private const val CHANNEL = "xiaomi"
    }
}