package io.agora.avc.receiver

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import io.agora.logger.Logger

class VolumeBroadcastReceiver : BroadcastReceiver() {

    var volumeChangeListener: ((Intent?) -> Unit)? = null

    override fun onReceive(context: Context?, intent: Intent?) {
        Logger.i(TAG, "on volume changed")
        volumeChangeListener?.invoke(intent)
    }

    companion object {
        private const val TAG = "[Comm][VolumeBroadcast]"
        const val VOLUME_CHANGED_ACTION = "android.media.VOLUME_CHANGED_ACTION"
    }
}