package io.agora.avc.repository

import io.agora.avc.bo.AppConfig
import io.agora.avc.bo.AppTips
import io.agora.avc.bo.AppVersion
import io.agora.avc.bo.DevConfig
import io.reactivex.Observable

interface AppConfigRepository {

    /**
     * query app config
     * @param appVersionName app version name, like "5.3.0"
     * @param type 0 : main version, 1 : NASA version
     * @param language current local language
     */
    fun queryAppVer(appVersionName: String, type: Int, language: String): Observable<AppVersion>
    fun getAppVer(): AppVersion?

    fun queryAppConfig(appVersionName: String, type: Int, view: String): Observable<AppConfig>
    fun getAppConfig(): AppConfig?
    fun saveAppConfig(appConfig: AppConfig?)

    fun getLastVersion(): String
    fun saveLastVersion(value: String)

    fun getUpgradeNotice(): String
    fun saveUpgradeNotice(value: String)

    fun getDarkTheme(): Int
    fun saveDarkTheme(value: Int)

    fun getDevelopMode(): Boolean
    fun saveDevelopMode(value: Boolean)

    fun getShowWelcome(): Boolean
    fun saveShowWelcome(value: Boolean)

    fun privacyShowed(): Boolean
    fun saveShowPrivacy(value: Boolean)

    fun getPictureMode(): Boolean
    fun savePictureMode(value: Boolean)

    fun isTestServer(): Boolean
    fun saveTestServer(value: Boolean)

    fun getAvcGuid(): String
    fun saveAvcGuid(value: String)

    fun clearToken()
    fun getAppTips(): AppTips?
    fun saveAppTips(appTips: AppTips)
    fun clearAppTips()

    fun getRtcParameters(): Set<String>
    fun saveRtcParameters(value: Set<String>)
    fun saveRoomMode(mode: Int)
    fun getRoomMode(): Int
    fun saveDevConfig(config: DevConfig)
    fun getDevConfig(): DevConfig

    fun saveOpenNotificationGuideTime(time: Long)
    fun getOpenNotificationGuideTime(): Long?

    fun saveBannerNotificationGuideTime(time: Long)
    fun getBannerNotificationGuideTime(): Long?

    var needShowFraudTips: Boolean
}