package io.agora.avc.repository

import io.agora.avc.app.developer.DeveloperOptions

/**
 * developer model repository
 */
interface DeveloperRepository {

    fun getDeveloperOptions() : DeveloperOptions

    fun isMetaDataEnable(): Boolean
    fun metaDataEnable(enable: Boolean)

    fun isRtmEnable(): Boolean
    fun rtmEnable(enable: Boolean)

    fun isDataChannelEnable(): Boolean
    fun dataChannelEnable(enable: Boolean)

    fun isLastMileEnable(): Boolean
    fun lastMileEnable(enable: Boolean)

    fun isShowVideoData(): Boolean
    fun showVideoData(show: Boolean)

    fun isVideoScoreEnable(): Boolean
    fun videoScoreEnable(enable: Boolean)

    fun isChangeMainScreenVideoBG(): Boolean
    fun changeMainScreenVideoBG(change: Boolean)

    /**
     * report quality when user leave room
     */
    fun isQualityReport(): Boolean
    fun qualityReport(open: Boolean)
    fun wifiAp(open: Boolean)

    fun loginWeWork(login: Boolean)
    fun showDeveloper(show: Boolean)
    fun openNetworkEvaluation(open: Boolean)

}