package io.agora.avc.repository.impl

import io.agora.avc.manager.splite.SPLite
import io.agora.avc.manager.splite.SPLiteImp
import io.agora.avc.repository.MediaConfigRepository
import io.agora.frame.base.BaseModel
import io.agora.frame.data.IDataRepository
import io.agora.logger.LogConverter
import io.agora.logger.Logger
import javax.inject.Inject

class MediaConfigRepositoryImpl @Inject constructor(dataRepository: IDataRepository?) :
    BaseModel(dataRepository), MediaConfigRepository {

    private val spLite: SPLite = SPLiteImp()

    override fun getAudioSetting(): Boolean {
        return spLite.getAudioSetting().apply {
            Logger.i(TAG, "get audio setting:${LogConverter.muted(this.not())}")
        }
    }

    override fun saveAudioSetting(value: Boolean) {
        Logger.i(TAG, "save audio setting:${LogConverter.muted(value.not())}")
        spLite.setAudioSetting(value)
    }

    override fun getVideoSetting(): Boolean {
        return spLite.getVideoSetting().apply {
            Logger.i(TAG, "get video setting:${LogConverter.muted(this.not())}")
        }
    }

    override fun saveVideoSetting(value: Boolean) {
        Logger.i(TAG, "save video setting:${LogConverter.muted(value.not())}")
        spLite.setVideoSetting(value)
    }

    override fun getResolutionOption(): Int {
        return spLite.getResolutionOption().apply {
            Logger.i(TAG, "get resolution option:${this}")
        }
    }

    override fun saveResolutionOption(value: Int) {
        Logger.i(TAG, "save resolution option:${value}")
        spLite.setResolutionOption(value)
    }

    companion object {
        private const val TAG = "[Repository][mediaConfig]"
    }
}