package io.agora.avc.service

import android.app.IntentService
import android.content.Intent
import android.os.IBinder
import com.agora.valoran.Constants
import dagger.android.AndroidInjection
import io.agora.avc.biz.AppController
import io.agora.avc.bo.MeetingNotificationType
import io.agora.avc.bo.NoticeCode
import io.agora.avc.manager.notice.NoticeEvent
import io.agora.avc.manager.notice.NoticeManager
import io.agora.avc.manager.notice.NoticeType
import io.agora.avc.receiver.MediaRequestReceiver
import javax.inject.Inject

class RequestService : IntentService("request_service") {

    @Inject
    lateinit var appController: AppController

    @Inject
    lateinit var noticeManager: NoticeManager

    override fun onCreate() {
        super.onCreate()
        AndroidInjection.inject(this)
    }

    override fun onBind(intent: Intent?): IBinder? {
        return null
    }

    override fun onHandleIntent(intent: Intent?) {
        val appContext = applicationContext
        val action = intent?.getBooleanExtra(MediaRequestReceiver.ACTION_CONFIRM, false) ?: false
        when (intent?.action) {
            MediaRequestReceiver.MEETING_EVENT_ACTION_AUDIO -> {
                if (action) {
                    appController?.setLocalAudio(action)
                } else {
                    appController?.refuseMediaRequest(Constants.RequestType.getValue(Constants.RequestType.AUDIO))
                }
                appContext?.let {
                    MediaRequestReceiver.dismissRequestNotification(it, true)
                }
                noticeManager?.notice(
                    NoticeEvent(
                        NoticeCode.CODE_PEER_INVITE_MICROPHONE_RECEIVE,
                        NoticeType.NOTIFICATION_B,
                        MeetingNotificationType.NO_2,
                        show = false
                    )
                )
            }
            MediaRequestReceiver.MEETING_EVENT_ACTION_VIDEO -> {
                if (action) {
                    appController?.setLocalVideo(action)
                } else {
                    appController?.refuseMediaRequest(Constants.RequestType.getValue(Constants.RequestType.VIDEO))
                }
                appContext?.let {
                    MediaRequestReceiver.dismissRequestNotification(it, false)
                }
                noticeManager?.notice(
                    NoticeEvent(
                        NoticeCode.CODE_PEER_INVITE_CAMERA_RECEIVE,
                        NoticeType.NOTIFICATION_B,
                        MeetingNotificationType.NO_6,
                        show = false
                    )
                )
            }
        }
    }

}