package io.agora.avc.utils

import android.content.pm.PackageManager
import android.os.Build
import io.agora.avc.MyApplication

object DeviceUtils {

    fun isSupportPicInPic(): Boolean {
        return Build.VERSION.SDK_INT >= Build.VERSION_CODES.N &&
                MyApplication.app.packageManager.hasSystemFeature(PackageManager.FEATURE_PICTURE_IN_PICTURE)
    }

    fun getPlatform(): String {
        return "android"
    }

    fun getModel(): String {
        var model = Build.MODEL
        model = model?.trim { it <= ' ' }?.replace("\\s*".toRegex(), "") ?: ""
        return "android ${getSDKVersionName()} $model"
    }

    fun getBrand(): String {
        return Build.BRAND
    }

    /**
     * Return version code of device's system.
     *
     * @return version code of device's system
     */
    fun getSDKVersionCode(): Int {
        return Build.VERSION.SDK_INT
    }

    /**
     * Return the version name of device's system.
     *
     * @return the version name of device's system
     */
    fun getSDKVersionName(): String {
        return Build.VERSION.RELEASE
    }

}