package io.agora.avc.utils

import android.content.res.AssetManager
import android.os.Environment
import android.text.TextUtils
import io.agora.avc.MyApplication
import java.io.*

object FileUtils {

    private fun writeFileFromIS(file: File, `is`: InputStream): Boolean {
        var os: OutputStream? = null
        return try {
            os = BufferedOutputStream(FileOutputStream(file))
            val data = ByteArray(8192)
            var len: Int
            while (`is`.read(data, 0, 8192).also { len = it } != -1) {
                os.write(data, 0, len)
            }
            true
        } catch (e: IOException) {
            e.printStackTrace()
            false
        } finally {
            try {
                `is`.close()
            } catch (e: IOException) {
                e.printStackTrace()
            }
            try {
                os?.close()
            } catch (e: IOException) {
                e.printStackTrace()
            }
        }
    }

    /**
     * \sdcard\Android\data\包名\files\type
     * \data\data\包名\files
     *
     * @param documentName
     * @return
     */
    fun getFileDir(documentName: String?): File {
        var file: File? = null
        if (Environment.getExternalStorageState() == Environment.MEDIA_MOUNTED) {
            file = MyApplication.app.getExternalFilesDir(documentName)
        }
        if (file == null) {
            file = MyApplication.app.filesDir
        }
        return file!!
    }

    fun getDirPath(documentName: String): String? {
        val absolutePath: String = getFileDir(null).absolutePath
        if (TextUtils.isEmpty(absolutePath)) {
            return null
        }
        val documentDir = File(absolutePath + File.separator + documentName + File.separator)
        if (!documentDir.exists()) {
            documentDir.mkdir()
        }
        return documentDir.absolutePath
    }

    fun copyAssetFile(pathname: String, assetFileName: String): Boolean {
        val assets: AssetManager = MyApplication.app.assets
        var inputStream: InputStream? = null
        try {
            val file = File(pathname)
            if (FileUtils2.isFileExists(file)) {
                FileUtils2.delete(file)
            }
           FileUtils2.createOrExistsFile(pathname)
            inputStream = assets.open(assetFileName)
            return writeFileFromIS(file, inputStream)
        } catch (e: IOException) {
            e.printStackTrace()
        } finally {
            if (inputStream != null) {
                try {
                    inputStream.close()
                } catch (e: IOException) {
                    e.printStackTrace()
                }
            }
        }
        return false
    }

}