package io.agora.avc.utils

import android.content.pm.PackageManager
import android.os.Bundle
import io.agora.avc.MyApplication

object MetaDataUtils {

    fun getString(key: String): String? {
        val metaData = getMetaData()
        return metaData?.getString(key)
    }

    private fun getMetaData(): Bundle? {
        val applicationInfo = MyApplication.appContext.packageManager.getApplicationInfo(
            MyApplication.appContext.packageName,
            PackageManager.GET_META_DATA
        )
        return applicationInfo.metaData
    }

}