package io.agora.avc.utils

object MimeTypeUtils {
    const val MIME_TYPE_IMAGE = "image/*"
    const val MIME_TYPE_VIDEO = "video/mp4"
    const val MIME_TYPE_IMAGE_PREFIX = "image/"

    fun isVideo(mimeType: String?): Boolean {
        if (mimeType == MIME_TYPE_VIDEO) {
            return true
        }
        return false
    }

    fun isImage(mimeType: String?): Boolean {
        if (mimeType == null) {
            return false
        }
        if (mimeType.startsWith(MIME_TYPE_IMAGE_PREFIX)) {
            return true
        }
        return false
    }

}