package io.agora.avc.utils

import android.content.Context
import android.content.res.Configuration
import android.util.TypedValue
import io.agora.avc.R

object ThemeUtils {

    fun isNightMode(context: Context?): Boolean {
        val uiMode = context?.resources?.configuration?.uiMode ?: Configuration.UI_MODE_NIGHT_NO
        val currentNightMode = uiMode and Configuration.UI_MODE_NIGHT_MASK
        if (currentNightMode == Configuration.UI_MODE_NIGHT_YES) {
            return true
        }
        return false
    }

    fun getAttrValue(context: Context, attrId: Int): Int {
        val typedValue = TypedValue()
        context.theme.resolveAttribute(attrId, typedValue, true)
        return typedValue.data
    }
}