package io.agora.avc.widget

import android.content.Context
import com.google.android.material.dialog.MaterialAlertDialogBuilder
import io.agora.avc.R

class AppNoticeDialog : MaterialAlertDialogBuilder {
    constructor(context: Context, notice: String) : this(
        context,
        R.style.CustomMaterialAlertDialog,
        notice
    )

    constructor(context: Context, int: Int, notice: String) : super(context, int) {
        setTitle(R.string.app_notice)
            .setMessage(notice)
            .setPositiveButton(R.string.got_it) { _, _ -> }
            .setCancelable(false)
    }
}