package io.agora.avc.widget

import android.content.Context
import android.view.LayoutInflater
import androidx.databinding.DataBindingUtil
import com.google.android.material.dialog.MaterialAlertDialogBuilder
import io.agora.avc.R
import io.agora.avc.databinding.DialogChooseAttachmentSourceBinding
import io.agora.avc.databinding.DialogChoosePictureSourceBinding

class AttachmentChooseDialog : MaterialAlertDialogBuilder {

    private var menuClickListener: OnMenuClickListener? = null

    constructor(
        context: Context,
        int: Int = R.style.CustomMaterialAlertDialog
    ) : super(context, int) {

        val dialogBinding = DataBindingUtil.inflate<DialogChooseAttachmentSourceBinding>(
            LayoutInflater.from(context),
            R.layout.dialog_choose_attachment_source,
            null,
            false
        )

        dialogBinding.choose0.setOnClickListener {
            menuClickListener?.takeFromLibrary()
        }

        dialogBinding.choose1.setOnClickListener {
            menuClickListener?.takeFromCamera()
        }

        dialogBinding.cancel.setOnClickListener {
            menuClickListener?.cancel()
        }
        setView(dialogBinding.root)
    }

    fun setOnMenuClickListener(listener: OnMenuClickListener): AttachmentChooseDialog {
        this.menuClickListener = listener
        return this
    }

    interface OnMenuClickListener {
        fun takeFromLibrary()
        fun takeFromCamera()
        fun cancel()
    }
}