package io.agora.avc.widget

import android.content.Context
import android.util.AttributeSet
import android.util.TypedValue
import androidx.appcompat.widget.AppCompatTextView
import io.agora.avc.R


/***
 * Created by liqilin on 2019-09-25
 *
 */
class ChatSendIndicatorText @JvmOverloads constructor(
    context: Context,
    attributeSet: AttributeSet? = null,
    defStyleAttr: Int = 0
) : AppCompatTextView(context, attributeSet, defStyleAttr) {

    private val normalColor: Int = textColors.defaultColor
    private val errorColor: Int

    init {
        val typedValue = TypedValue()
        context.theme.resolveAttribute(R.attr.colorError, typedValue, true)
        errorColor = typedValue.data
    }

    fun sending() {
        setText(R.string.chat_sending)

        setTextColor(normalColor)
    }

    fun sendFailure() {
        setText(R.string.chat_send_failure)

        setTextColor(errorColor)
    }
}