package io.agora.avc.widget

import android.animation.Animator
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.view.doOnLayout
import androidx.core.view.isVisible
import androidx.core.view.updatePaddingRelative
import io.agora.avc.R
import io.agora.avc.utils.ConvertUtils
import io.agora.logger.Logger

class ConnectingView {

    private val marginStart = ConvertUtils.dp2px(8f)
    private var connectingView: View? = null
    private var insetLeft: Int = 0
    private var insetTop: Int = 0

    private var isShowing = false

    var isVisible
        set(value) {
            connectingView?.isVisible = value
        }
        get() = connectingView?.isVisible == true

    fun isShowing() = isShowing

    fun onApplyWindowInsets(
        insetLeft: Int,
        insetTop: Int
    ) {
        Logger.i(TAG, "onApplyWindowInsets: insetLeft=${insetLeft}, insetTop=${insetTop}")
        this.insetLeft = insetLeft + marginStart
        this.insetTop = insetTop + marginStart
        connectingView?.updatePaddingRelative(
            start = marginStart + insetLeft,
            top = marginStart + insetTop
        )
    }

    fun show(parent: ViewGroup) {
        Logger.i(TAG, "showing")
        connectingView = LayoutInflater.from(parent.context).inflate(
            R.layout.layout_connecting,
            parent, false
        ).apply {
            parent.addView(this)
            if (insetLeft != 0 || insetTop != 0) {
                updatePaddingRelative(
                    start = insetLeft,
                    top = insetTop
                )
            }
            isShowing = true
            doOnLayout {
                translationX = -(it.width.toFloat() + marginStart)
                animate().apply {
                    translationX(0f)
                    duration = 500
                }.start()
            }
        }
    }

    fun hide(action: () -> Unit) {
        if (isShowing) {
            connectingView?.apply {
                animate().apply {
                    translationX(-(width.toFloat() + marginStart))
                    duration = 500
                    setListener(object : Animator.AnimatorListener {
                        override fun onAnimationStart(animation: Animator?) {

                        }

                        override fun onAnimationEnd(animation: Animator?) {
                            (connectingView?.parent as? ViewGroup)?.removeView(connectingView)
                            isShowing = false
                            Logger.i(TAG, "hide")
                            action.invoke()
                        }

                        override fun onAnimationCancel(animation: Animator?) {

                        }

                        override fun onAnimationRepeat(animation: Animator?) {

                        }

                    })
                }.start()
            }
        }
    }

    companion object {
        private const val TAG = "[UI][MeetingConnectingView]"
    }
}