package io.agora.avc.widget

import android.app.Activity
import android.graphics.Typeface
import android.text.Spannable
import android.text.SpannableString
import android.text.style.StyleSpan
import android.view.LayoutInflater
import android.view.View
import androidx.annotation.StringRes
import io.agora.avc.R
import io.agora.avc.databinding.PopCopyLinkBinding
import io.agora.avc.utils.StringUtils

class CopyLinkPopupWindow constructor(
    activity: Activity,
    private val roomName: String,
    private val password: String = "",
    private val onClickListener: View.OnClickListener
) : TipPopupWindow(activity) {

    private val binding: PopCopyLinkBinding by lazy {
        PopCopyLinkBinding.inflate(LayoutInflater.from(activity))
    }

    override fun getCustomView(): View {
        binding.tvRoomName.text = getSpan(R.string.room_info_name, roomName)
        binding.tvPassword.text = getSpan(R.string.room_info_passward, password)

        binding.btnCopyLink.setOnClickListener {
            onClickListener.onClick(it)
            dismiss()
        }
        return binding.root
    }

    private fun getSpan(@StringRes stringRes: Int, text: String): SpannableString {
        return SpannableString(activity.getString(stringRes, text)).apply {
            if (!StringUtils.isEmpty(text)) {
                setSpan(
                    StyleSpan(Typeface.BOLD),
                    length - text.length,
                    length,
                    Spannable.SPAN_INCLUSIVE_INCLUSIVE
                )
            }
        }
    }
}