package io.agora.avc.widget

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.ImageView.ScaleType
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.view.isVisible
import io.agora.avc.R
import io.agora.avc.databinding.LayoutDotIconViewBinding

class DotIconView @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0
) : ConstraintLayout(context, attrs, defStyleAttr) {

    private val binding =
        LayoutDotIconViewBinding.inflate(LayoutInflater.from(context), this, true)

    var hasUnread = false
        set(value) {
            field = value
            binding.ivDot.isVisible = value
        }

    init {

        context.obtainStyledAttributes(attrs, R.styleable.DotIconView).apply {
            getInt(R.styleable.DotIconView_android_scaleType, 3).let {
                binding.ivChat.scaleType = sScaleTypeArray[it]
            }
            getDrawable(R.styleable.DotIconView_android_src).let {
                binding.ivChat.setImageDrawable(it)
            }
            binding.ivChat.imageTintList = getColorStateList(R.styleable.DotIconView_tint)
            recycle()
        }

        binding.ivDot.isVisible = hasUnread
    }

    companion object {
        private val sScaleTypeArray = arrayOf(
            ScaleType.MATRIX,
            ScaleType.FIT_XY,
            ScaleType.FIT_START,
            ScaleType.FIT_CENTER,
            ScaleType.FIT_END,
            ScaleType.CENTER,
            ScaleType.CENTER_CROP,
            ScaleType.CENTER_INSIDE
        )
    }
}