package io.agora.avc.widget

import android.app.Dialog
import android.content.Context
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.view.Window
import android.widget.TextView
import io.agora.avc.R

class LoadingDialog(context: Context) : Dialog(context) {

    private var tvContent: TextView? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        requestWindowFeature(Window.FEATURE_NO_TITLE)

        window?.setBackgroundDrawable(ColorDrawable(android.graphics.Color.TRANSPARENT))
//        window?.clearFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND)

        setCancelable(false)

        setContentView(R.layout.layout_progress)

        tvContent = findViewById(R.id.progress_content)
    }

    fun setContent(content: String) {
        tvContent?.text = content
    }
}
