package io.agora.avc.widget

import android.app.Activity
import android.view.LayoutInflater
import android.view.View
import android.widget.TextView
import io.agora.avc.R

/***
 * Created by liqilin on 2019-09-24
 *
 */
//Avoid context name conflict with TipPopupWindow activity
class MediaPopupWindow(activity: Activity, var tipType: Int = TIP_TYPE_MICROPHONE) :
    TipPopupWindow(activity) {

    override fun getCustomView(): View {
        val view =
            LayoutInflater.from(activity).inflate(R.layout.layout_media_tip, container, false)

        (view.findViewById<View>(R.id.reminder_content) as TextView).setText(getTipContent())
        return view
    }

    fun getTipContent(): Int {
        return when (tipType) {
            TIP_TYPE_MICROPHONE -> R.string.room_default_microphone
            TIP_TYPE_CAMERA -> R.string.room_default_camera
            else -> R.string.room_default_both
        }
    }
}