package io.agora.avc.widget

import android.app.Activity
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import io.agora.avc.databinding.PopMediaVideoBinding
import io.agora.avc.utils.ScreenUtils

class MediaVideoPopupWindow constructor(
    activity: Activity,
    private val onClickListener: View.OnClickListener
) : TipPopupWindow(activity) {

    private val binding: PopMediaVideoBinding by lazy {
        PopMediaVideoBinding.inflate(LayoutInflater.from(activity))
    }

    override fun getCustomView(): View {
        width = (ScreenUtils.getScreenWidth() * 0.53f).toInt()
        height = ViewGroup.LayoutParams.WRAP_CONTENT
        binding.clContent.layoutParams = ViewGroup.LayoutParams(width, height)

        binding.llCloseVideo.setOnClickListener {
            onClickListener.onClick(it)
            dismiss()
        }
        binding.llConvertCamera.setOnClickListener {
            onClickListener.onClick(it)
            dismiss()
        }
        return binding.root
    }
}