package io.agora.avc.widget

import android.content.Context
import android.util.AttributeSet
import android.view.MotionEvent
import android.widget.FrameLayout
import io.reactivex.Observable
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.disposables.Disposable
import io.reactivex.schedulers.Schedulers
import java.util.concurrent.TimeUnit

class MeetingRootLayout @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0
) : FrameLayout(context, attrs, defStyleAttr) {

    private var countTimer: Disposable? = null
    var timerCallBack: OnTimerCallBack? = null

    override fun onAttachedToWindow() {
        super.onAttachedToWindow()
        if (!isInEditMode) {
            startCountTime()
        }
    }

    override fun onDetachedFromWindow() {
        super.onDetachedFromWindow()
        stopCountTime()
        timerCallBack = null
    }

    fun screenFullEnable(enable: Boolean) {
        if (enable) {
            startCountTime()
        } else {
            stopCountTime()
        }
    }

    fun stopCountTime() {
        countTimer?.dispose()
    }

    fun startCountTime() {
        Observable
            .interval(INNER_SECOND, INNER_SECOND, TimeUnit.SECONDS)
            .subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe(object : io.reactivex.Observer<Long> {
                override fun onComplete() {

                }

                override fun onSubscribe(d: Disposable) {
                    stopCountTime()
                    countTimer = d
                }

                override fun onNext(t: Long) {
                    timerCallBack?.onDismiss()
                }

                override fun onError(e: Throwable) {

                }
            })
    }

    override fun dispatchTouchEvent(ev: MotionEvent?): Boolean {
        when (ev?.action) {
            MotionEvent.ACTION_DOWN -> {
                stopCountTime()
            }
            MotionEvent.ACTION_UP -> {
                startCountTime()
            }
        }
        return super.dispatchTouchEvent(ev)
    }

    interface OnTimerCallBack {
        fun onDismiss()
    }

    companion object {
        private const val INNER_SECOND_DEBUG = 5 * 60L
        private const val INNER_SECOND_RELEASE = 10L
        var INNER_SECOND = INNER_SECOND_RELEASE
    }
}