package io.agora.avc.widget

import android.content.Context
import android.graphics.Rect
import android.util.AttributeSet
import androidx.appcompat.widget.AppCompatImageView
import io.agora.avc.R

/***
 * Created by liqilin on 2019-08-30
 *
 */
class MenuMoreImageView @JvmOverloads constructor(
    context: Context,
    attributeSet: AttributeSet? = null,
    defStyleAttr: Int = 0
) : AppCompatImageView(context, attributeSet, defStyleAttr) {

    override fun onFocusChanged(gainFocus: Boolean, direction: Int, previouslyFocusedRect: Rect?) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect)

        if (gainFocus) {
            setImageResource(R.drawable.ic_more_focused)
        } else {
            setImageResource(R.drawable.ic_more)
        }
    }
}