package io.agora.avc.widget

import android.content.Context
import android.view.LayoutInflater
import androidx.databinding.DataBindingUtil
import com.google.android.material.dialog.MaterialAlertDialogBuilder
import io.agora.avc.R
import io.agora.avc.databinding.DialogChoosePictureSourceBinding

class PictureChooseDialog : MaterialAlertDialogBuilder {

    private var menuClickListener: OnMenuClickListener? = null

    constructor(
        context: Context,
        int: Int = R.style.CustomMaterialAlertDialog
    ) : super(context, int) {

        val dialogBinding = DataBindingUtil.inflate<DialogChoosePictureSourceBinding>(
            LayoutInflater.from(context),
            R.layout.dialog_choose_picture_source,
            null,
            false
        )

        dialogBinding.choose0.setOnClickListener {
            menuClickListener?.takeFromLibrary()
        }

        dialogBinding.choose1.setOnClickListener {
            menuClickListener?.takeFromCamera()
        }

        dialogBinding.cancel.setOnClickListener {
            menuClickListener?.cancel()
        }
        setView(dialogBinding.root)
    }

    fun setOnMenuClickListener(listener: OnMenuClickListener): PictureChooseDialog {
        this.menuClickListener = listener
        return this
    }

    interface OnMenuClickListener {
        fun takeFromLibrary()
        fun takeFromCamera()
        fun cancel()
    }
}