package io.agora.avc.widget

import android.content.Context
import android.text.method.LinkMovementMethod
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.CheckBox
import android.widget.FrameLayout
import android.widget.ScrollView
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.widget.AppCompatTextView
import androidx.core.content.ContextCompat
import com.google.android.material.dialog.MaterialAlertDialogBuilder
import io.agora.avc.R


class PrivacyTermsDialog {

    private var mContext: Context

    private var checkBox: CheckBox? = null

    private var tvTerms: AppCompatTextView? = null

    private var scrollView: ScrollView? = null

    private var frameLayout: FrameLayout? = null

    private var mDialog: AlertDialog? = null

    private var mDialogBuilder: MaterialAlertDialogBuilder? = null

    private var mDialogListener: OnPrivacyTermsDialogListener? = null

    constructor(context: Context) {
        this.mContext = context
    }

    private fun initView() {
        // Why changed from WebView to TextView, see: https://jira.agoralab.co/browse/APP-1092
        val customView =
            LayoutInflater.from(mContext).inflate(R.layout.layout_user_terms_text_view, null)
        tvTerms = customView.findViewById(R.id.tvTerms)
        tvTerms?.movementMethod = LinkMovementMethod.getInstance()
        checkBox = customView.findViewById(R.id.termsCheck)
        scrollView = customView.findViewById(R.id.content)
        frameLayout = FrameLayout(mContext).apply {
            addView(
                customView,
                FrameLayout.LayoutParams(
                    ViewGroup.LayoutParams.MATCH_PARENT,
                    ViewGroup.LayoutParams.MATCH_PARENT
                ).apply {
                    val margin = resources.getDimensionPixelOffset(R.dimen.inset_start_medium)
                    setMargins(margin, margin, margin, 0)
                })
        }
    }

    fun show(privacyShowed: Boolean) {
        initView()
        mDialogBuilder = MaterialAlertDialogBuilder(mContext, R.style.CustomMaterialAlertDialog)
            .setTitle(R.string.terms_title)
            .setOnDismissListener {
                clearUI()
            }
            .setView(frameLayout)

        if (!privacyShowed) {
            mDialogBuilder?.setCancelable(false)
                ?.setPositiveButton(R.string.accept) { _, _ ->
                    mDialogListener?.onConfirmClick()
                }
                ?.setNegativeButton(R.string.decline) { _, _ ->
                    mDialogListener?.onCancelClick()
                }
        } else {
            mDialogBuilder?.setCancelable(true)
                ?.setPositiveButton(R.string.got_it) { _, _ -> }
        }

        mDialog = mDialogBuilder?.create()
        mDialog?.show() // !!! must before {dialog.getButton(AlertDialog.BUTTON_POSITIVE)}

        if (!privacyShowed) {
            val positive = mDialog?.getButton(AlertDialog.BUTTON_POSITIVE)
            val negative = mDialog?.getButton(AlertDialog.BUTTON_NEGATIVE)

            positive?.isEnabled = false
            negative?.setTextColor(ContextCompat.getColor(mContext, R.color.color_error))

            checkBox?.setOnCheckedChangeListener { _, isChecked ->
                positive?.isEnabled = isChecked
            }

            checkBox?.requestFocus()
        } else {
            checkBox?.visibility = View.GONE
        }
    }

    private fun clearUI() {
        val parent = frameLayout?.parent
        if (parent != null && parent is ViewGroup) {
            parent.removeAllViews()
        }
    }

    fun dismiss() {
        mDialog?.dismiss()
    }

    fun setPrivacyTermsDialogListener(listener: OnPrivacyTermsDialogListener) {
        this.mDialogListener = listener
    }

    interface OnPrivacyTermsDialogListener {
        fun onConfirmClick()
        fun onCancelClick()
    }
}