package io.agora.avc.widget

import android.content.Context
import android.graphics.Rect
import android.util.AttributeSet
import android.util.TypedValue
import androidx.appcompat.widget.AppCompatImageView
import io.agora.avc.R

/***
 * Created by liqilin on 2019-08-30
 *
 */
class SettingsIconView @JvmOverloads constructor(
    context: Context,
    attributeSet: AttributeSet? = null,
    defStyleAttr: Int = 0
) : AppCompatImageView(context, attributeSet, defStyleAttr) {

    var isMenu: Boolean = false

    override fun setClickable(clickable: Boolean) {
        super.setClickable(clickable)

        changeImageResource()
    }

    override fun onFocusChanged(gainFocus: Boolean, direction: Int, previouslyFocusedRect: Rect?) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect)

        changeImageResource()
    }

    private fun changeImageResource() {
        if (isClickable) {
            if (isFocused) {
                setImageResource(if (isMenu) R.drawable.menu_more_focused else R.drawable.ic_settings_focus)
            } else {
                setImageResource(if (isMenu) R.drawable.menu_more else R.drawable.ic_settings)
            }

            val typedValue = TypedValue()
            context.theme.resolveAttribute(R.attr.colorPrimary, typedValue, true)
            setColorFilter(typedValue.data)
        } else {
            setImageResource(if (isMenu) R.drawable.menu_more_unclickable else R.drawable.ic_settings_unclickable)
        }
    }
}