package io.agora.avc.widget

import android.content.Context
import android.content.res.ColorStateList
import android.util.AttributeSet
import android.util.TypedValue
import android.view.LayoutInflater
import android.view.View
import android.widget.FrameLayout
import androidx.annotation.StringRes
import androidx.appcompat.content.res.AppCompatResources
import io.agora.avc.R
import io.agora.avc.databinding.LayoutSettingsItemBinding


/***
 * Created by liqilin on 2019-09-11
 *
 */
class SettingsItemView @JvmOverloads constructor(
    context: Context,
    attributeSet: AttributeSet? = null,
    defStyleAttr: Int = 0
) : FrameLayout(context, attributeSet, defStyleAttr) {

    private var binding = LayoutSettingsItemBinding.inflate(
        LayoutInflater.from(context),
        this,
        true
    )
    private var tipText: CharSequence? = null
    private var isSwitch: Boolean = false
    private var isEnableIconTint: Boolean = true
    private var defaultColor: Int = 0
    private var tintColor: ColorStateList

    var callback: ((value: Boolean?) -> Unit)? = null

    init {
        val a = context.obtainStyledAttributes(attributeSet, R.styleable.SettingsItemView)

        /*************** ICON ************/

        val typedValue = TypedValue()
        context.theme.resolveAttribute(R.attr.colorPrimary, typedValue, true)
        defaultColor = typedValue.data

        isEnableIconTint = a.getBoolean(R.styleable.SettingsItemView_item_tint_icon, true)
        tintColor = if (isEnableIconTint) {
            AppCompatResources.getColorStateList(context, R.color.setting_icon_color_tint)!!
        } else {
            AppCompatResources.getColorStateList(context, R.color.setting_icon_alpha_tint)!!
        }

        /*************** FIRST TEXT ************/
        val firstText = a.getText(R.styleable.SettingsItemView_item_first_text)
        if (firstText.isNotEmpty()) {
            binding.itemFirstText.text = firstText
        } else {
            binding.itemFirstText.visibility = View.GONE
        }

        /*************** SECOND TEXT ************/
        if (a.hasValue(R.styleable.SettingsItemView_item_secondary_text)) {
            val description = a.getText(R.styleable.SettingsItemView_item_secondary_text)
            binding.itemSecondaryText.text = description
            binding.itemSecondaryText.visibility = View.VISIBLE
        }

        /*************** ACTION ************/
        if (a.hasValue(R.styleable.SettingsItemView_item_action_text)) {
            val actionText = a.getText(R.styleable.SettingsItemView_item_action_text)
            binding.btAction.setText(actionText.toString())
            binding.btAction.visibility = View.VISIBLE
            binding.btAction.setOnClickListener {
                callback?.run { this(null) }
            }
        }

        if (a.hasValue(R.styleable.SettingsItemView_item_action_switch)) {
            if (a.getBoolean(R.styleable.SettingsItemView_item_action_switch, false)) {
                isSwitch = true
                binding.btSwitch.visibility = View.VISIBLE

                binding.btSwitch.setOnCheckedChangeListener { _, isChecked ->
                    callback?.run { this(isChecked) }
                }
            }
        }

        a.recycle()

        binding.itemFirstText.isActivated = true

        isClickable = true

        setOnClickListener {
            if (isSwitch) {
                binding.btSwitch.performClick()
            } else {
                callback?.run { this(null) }
            }
        }

        // item click background
        val outValue = TypedValue()
        getContext().theme.resolveAttribute(android.R.attr.selectableItemBackground, outValue, true)
        setBackgroundResource(outValue.resourceId)
    }
    //
    fun setSecondaryText(text: String) {
        binding.itemSecondaryText.text = text
    }

    fun setSecondaryTextVisible(visible: Boolean) {
        if (visible) {
            binding.itemSecondaryText.visibility = View.VISIBLE
        } else {
            binding.itemSecondaryText.visibility = View.GONE
        }
    }

    fun setActionButtonText(text: String) {
        binding.btAction.setText(text)
    }

    fun getActionButtonText() = binding.btAction.getText()

    fun getActionButton() = binding.btAction

    fun setSwitchChecked(checked: Boolean) {
        // post delay skip SettingsItemView_item_switch_state
        binding.btSwitch.isChecked = checked
    }

    fun setActionEnabled(enabled: Boolean) {
        if (binding.btSwitch.visibility == View.VISIBLE) {
            binding.btSwitch.isEnabled = enabled
        } else {
            binding.btAction.isEnabled = enabled
        }

        binding.itemFirstText.isActivated = enabled

        isClickable = enabled
    }

    fun setTipsText(@StringRes resId: Int) {
        tipText = context.getString(resId)
    }
}