package io.agora.avc.widget

import android.app.Activity
import android.view.LayoutInflater
import android.view.View
import androidx.core.view.updateLayoutParams
import io.agora.avc.R
import io.agora.avc.bo.LastMile
import io.agora.avc.bo.NetworkQuality
import io.agora.avc.databinding.PopSignalQuality2Binding
import io.agora.avc.utils.ScreenUtils
import io.agora.avc.utils.StringUtils
import io.agora.avc.utils.ThemeUtils

class SignalQualityPopupWindow2 constructor(
    activity: Activity,
    private var lastMile: LastMile? = null,
) : TipPopupWindow(activity) {

    private val binding: PopSignalQuality2Binding by lazy {
        PopSignalQuality2Binding.inflate(LayoutInflater.from(activity))
    }

    override fun getCustomView(): View {
        setData(lastMile)
        container.updateLayoutParams {
            width = (ScreenUtils.getAppScreenWidth() * 0.94f).toInt()
        }
        return binding.root
    }

    fun setData(lastMile: LastMile?) {
        lastMile?.let {
            getQuality(it.quality).let { _pair ->
                binding.tvSignalQuality.text = StringUtils.getString(_pair.first)
                binding.tvSignalQuality.setTextColor(_pair.second)
            }

            binding.tvRTT.text = if (it.rtt == -1) " -" else " ${it.rtt}ms"
            binding.tvPacketSend.text = if (it.upLossRate == -1) "-" else "${it.upLossRate}%"
            binding.tvPacketReceive.text = if (it.downLossRate == -1) "-" else "${it.downLossRate}%"
            binding.tvJitterSend.text = if (it.upJitter == -1) "-" else "${it.upJitter}ms"
            binding.tvJitterReceive.text = if (it.downJitter == -1) "-" else "${it.downJitter}ms"
            binding.tvBandWithSend.text =
                if (it.upBandWidth == -1) "-" else "${it.upBandWidth.bpsConvertkbps()}kbps"
            binding.tvBandWithReceive.text =
                if (it.downBandWidth == -1) "-" else "${it.downBandWidth.bpsConvertkbps()}kbps"
        }
    }

    private fun getQuality(quality: Int): Pair<Int, Int> {
        return when (quality) {
            NetworkQuality.EXCELLENT,
            NetworkQuality.GOOD -> Pair(
                R.string.media_quality_good,
                ThemeUtils.getAttrValue(context = activity, R.attr.signalGoodColor)
            )
            NetworkQuality.POOR -> Pair(
                R.string.media_quality_poor,
                ThemeUtils.getAttrValue(context = activity, R.attr.signalSoftColor)
            )
            NetworkQuality.BAD,
            NetworkQuality.VBAD -> Pair(
                R.string.media_quality_bad,
                ThemeUtils.getAttrValue(context = activity, R.attr.signalPoorColor)
            )
            else -> Pair(
                R.string.media_quality_unknown,
                ThemeUtils.getAttrValue(context = activity, R.attr.signalUnknownColor)
            )
        }
    }

    private fun Int.bpsConvertkbps(): Int {
        return (this / 1000f).toInt()
    }
}