package io.agora.avc.widget

import android.content.Context
import android.graphics.drawable.ClipDrawable
import android.util.AttributeSet
import androidx.appcompat.content.res.AppCompatResources
import io.agora.avc.R

class SpeakingImageView @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0
) : CheckableImageView(context, attrs, defStyleAttr) {

    var speaking = false
        set(value) {
            field = value
            isChecked = value
        }

    var active = true
        set(value) {
            field = value
            isActivated = value
            if (value) {
                setImageResource(R.drawable.ic_unmute)
                volume = volume
            }
        }

    var volume = 30
        set(value) {
            field = value
            if (active) {
                (drawable as? ClipDrawable)?.level = value * 10000 / 255
            }
        }

    init {
//        setBackgroundResource(R.drawable.ic_audio_bg)
        setImageResource(R.drawable.ic_mute)
        setBackgroundResource(R.drawable.bg_circle_small)
        backgroundTintList =
            AppCompatResources.getColorStateList(context, R.color.selector_speaking_bg)
    }

}