package io.agora.avc.widget

import android.content.Context
import android.graphics.PorterDuff
import android.graphics.drawable.Drawable
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.widget.FrameLayout
import android.widget.ProgressBar
import androidx.appcompat.widget.AppCompatImageView
import androidx.core.content.ContextCompat
import androidx.core.graphics.drawable.DrawableCompat
import io.agora.avc.R

open class StateView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : FrameLayout(context, attrs, defStyleAttr) {

    private lateinit var stateImage: AppCompatImageView
    private lateinit var loadingView: ProgressBar
    private var stateType: Int
    private var normalDrawable: Drawable? = null
    private var tintColor: Int = -1

    init {
        val a = context.obtainStyledAttributes(attrs, R.styleable.StateView)
        stateType = a.getInt(R.styleable.StateView_stateType, 0)
        normalDrawable = a.getDrawable(R.styleable.StateView_normalDrawable)
        tintColor = a.getColor(R.styleable.StateView_tintColor, -1)
        a.recycle()
    }

    override fun onFinishInflate() {
        super.onFinishInflate()
        LayoutInflater.from(context).inflate(R.layout.layout_state_view, this)
        stateImage = findViewById(R.id.stateImage)
        setNormalDrawable(normalDrawable)
        loadingView = findViewById(R.id.loadingView)
        loadingView.indeterminateDrawable?.setColorFilter(
            ContextCompat.getColor(
                context,
                R.color.colorGray
            ), PorterDuff.Mode.SRC_IN
        )

        refreshState()
    }

    fun setState(state: Int) {
        if (stateType != state) {
            stateType = state
            refreshState()
        }
    }

    fun setNormalDrawable(drawable: Drawable?) {
        normalDrawable = drawable
        if (normalDrawable != null && tintColor != -1) {
            DrawableCompat.setTint(normalDrawable!!, tintColor)
        }
        stateImage.setImageDrawable(normalDrawable)
    }

    private fun refreshState() {
        when (stateType) {
            NORMAL -> {
                stateImage.visibility = View.VISIBLE
                loadingView.visibility = View.GONE
            }
            LOADING -> {
                stateImage.visibility = View.GONE
                loadingView.visibility = View.VISIBLE
            }
        }
    }

    companion object {
        const val NORMAL = 0
        const val LOADING = 1
    }

}
