package io.agora.avc.widget

import android.app.Activity
import android.view.LayoutInflater
import android.view.View
import android.widget.TextView
import androidx.annotation.StringRes
import androidx.appcompat.widget.AppCompatTextView
import io.agora.avc.R

/***
 * Created by liqilin on 2019-09-24
 *
 */
class TextPopupWindow constructor(activity: Activity) : TipPopupWindow(activity) {

    var text: CharSequence? = null
    var textView: TextView? = null

    constructor(activity: Activity, textString: CharSequence) : this(activity) {
        text = textString
    }

    constructor(activity: Activity, @StringRes textId: Int) : this(activity) {
        text = activity.getText(textId)
    }

    override fun getCustomView(): View {
        textView = LayoutInflater.from(activity)
            .inflate(R.layout.layout_text_tip, container, false) as AppCompatTextView

        textView?.text = text

        return textView!!
    }

    fun updateText(textString: CharSequence) {
        text = textString

        textView?.text = textString
    }
}