package io.agora.avc.widget

import android.content.Context
import android.util.AttributeSet
import io.agora.avc.R

class UploadLogButton @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0
) : LoadingStatusTextButton(context, attrs, defStyleAttr) {

    init {
        normalText = context.getString(R.string.upload_log_button)
        successText = context.getString(R.string.upload_log_success_button)
        failText = context.getString(R.string.upload_log_fail_button)

        onStatusChangedListener = { state, _ ->
            when (state) {
                State.FAIL,
                State.SUCCESS -> {
                    resetCountdown()
                }
            }
        }
    }

    fun canUpload() = state == State.NORMAL || state == State.FAIL
}
