package io.agora.avc.widget

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import com.google.android.material.dialog.MaterialAlertDialogBuilder
import io.agora.avc.R
import io.agora.avc.manager.rating.video.Rating
import io.agora.avc.manager.rating.video.VideoScore

class VideoRatingDialog : MaterialAlertDialogBuilder {

    private var ratingClickListener: OnRatingClickListener? = null

    constructor(
        context: Context,
        int: Int = R.style.CustomMaterialAlertDialog,
        videoScore: VideoScore
    ) : super(context, int) {
        val customView =
            LayoutInflater.from(context).inflate(R.layout.dialog_choose_video_rating_result, null)
        customView.findViewById<View>(R.id.choose0).setOnClickListener {
            videoScore.score = Rating.GOOD
            ratingClickListener?.onRatingClick(videoScore)
        }
        customView.findViewById<View>(R.id.choose1).setOnClickListener {
            videoScore.score = Rating.MEDIUM
            ratingClickListener?.onRatingClick(videoScore)
        }
        customView.findViewById<View>(R.id.choose2).setOnClickListener {
            videoScore.score = Rating.POOR
            ratingClickListener?.onRatingClick(videoScore)
        }
        setView(customView)
        setCancelable(false)
    }

    fun setOnRatingClickListener(listener: OnRatingClickListener): VideoRatingDialog {
        this.ratingClickListener = listener
        return this
    }

    interface OnRatingClickListener {
        fun onRatingClick(videoScore: VideoScore)
    }
}