package io.agora.avc.widget

import android.app.AlertDialog
import android.app.Dialog
import android.content.Context
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.view.LayoutInflater
import android.view.Window
import androidx.databinding.DataBindingUtil
import io.agora.avc.R
import io.agora.avc.databinding.DialogWatermarkRequestBinding

class WatermarkRequestDialog(context: Context) : Dialog(context) {

    private var onItemClickListener: OnItemClickListener? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        requestWindowFeature(Window.FEATURE_NO_TITLE)

        window?.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))

        setCancelable(true)
        val dialogBinding = DataBindingUtil.inflate<DialogWatermarkRequestBinding>(
            LayoutInflater.from(context),
            R.layout.dialog_watermark_request,
            null,
            false
        )

        dialogBinding?.btnCancel?.setOnClickListener {
            onItemClickListener?.onCancelClick()
        }

        dialogBinding?.btnConfirm?.setOnClickListener {
            onItemClickListener?.onConfirmClick()
        }

        setContentView(dialogBinding.root)
    }

    fun showDialog(): Dialog {
        super.show()
        return this
    }

    fun setOnItemClickListener(listener: OnItemClickListener): WatermarkRequestDialog {
        this.onItemClickListener = listener
        return this
    }

    interface OnItemClickListener {
        fun onCancelClick()
        fun onConfirmClick()
    }
}
