package io.agora.avc.widget

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import androidx.appcompat.app.AlertDialog
import androidx.databinding.DataBindingUtil
import com.google.android.material.dialog.MaterialAlertDialogBuilder
import io.agora.avc.R
import io.agora.avc.databinding.DialogWeWorkLoginBinding

const val TYPE_COMPANY: String = "type_company"
const val COMPANY_AGORA: Int = 1
const val COMPANY_EASEMOB: Int = 2

class WeWorkLoginDialog : MaterialAlertDialogBuilder {

    private var menuClickListener: OnMenuClickListener? = null
    private var wwAppInstalled: Boolean = false
    private var dialogBinding: DialogWeWorkLoginBinding? = null
    private var type = COMPANY_AGORA

    constructor(
        context: Context,
        int: Int = R.style.CustomMaterialAlertDialog,
        type: Int
    ) : super(context, int) {
        this.type = type
        dialogBinding = DataBindingUtil.inflate(
            LayoutInflater.from(context),
            R.layout.dialog_we_work_login,
            null,
            false
        )

        dialogBinding?.choose0?.setOnClickListener {
            menuClickListener?.loginWithPassword(type)
        }

        dialogBinding?.choose1?.setOnClickListener {
            menuClickListener?.loginWithQr(type)
        }

        dialogBinding?.choose2?.setOnClickListener {
            menuClickListener?.loginWithEmail()
        }

        dialogBinding?.cancel?.setOnClickListener {
            menuClickListener?.cancel()
        }
        setView(dialogBinding?.root)
    }

    fun setWWAppInstalled(installed: Boolean): WeWorkLoginDialog {
        this.wwAppInstalled = installed
        return this
    }

    fun setOnMenuClickListener(listener: OnMenuClickListener): WeWorkLoginDialog {
        this.menuClickListener = listener
        return this
    }

    override fun show(): AlertDialog {
        if (!wwAppInstalled) {
            dialogBinding?.choose0?.visibility = View.GONE
            dialogBinding?.divider2?.visibility = View.GONE
        }
        return super.show()
    }

    interface OnMenuClickListener {
        fun loginWithPassword(type: Int)
        fun loginWithQr(type: Int)
        fun loginWithEmail()
        fun cancel()
    }
}