package io.agora.avc.widget.danceview;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Shader;


import java.util.concurrent.atomic.AtomicBoolean;

import io.agora.avc.utils.ConvertUtils;
import io.agora.logger.Logger;

public class NougatBoot extends SpriteContainer {
    private final String TAG = "NougatBoot2";
    private final ValueAnimator valueAnimator;
    private final AtomicBoolean dancing = new AtomicBoolean(false);

    public NougatBoot() {
        this.valueAnimator = ObjectAnimator.ofFloat(0f, 1f);
        valueAnimator.setDuration(1000);
    }

    @Override
    public Sprite[] onCreateChild() {
        return new Sprite[]{
                new Circle(Color.parseColor("#00BFFF"), Color.parseColor("#B620E0"), 0, 360),
                new Circle(Color.parseColor("#B620E0"), Color.parseColor("#F7B500"), 72, -288),
        };
    }

    @Override
    public void start() {
        if (dancing.get()) {
            super.start();
        }
    }

    @Override
    public void setColor(int color) {
        // disable color
    }

    class Circle extends ShapeSprite {

        private int startAngle, endAngle;
        private float[] p0, p1, p2, p3, c0, c1, c2, c3, c4, c5, c6, c7;
        private Path path;
        private int strokeWidth;
        private int startColor;
        private int endColor;
        private int margin;
        private float[] circleC0, circleC1, circleC2, circleC3, circleC4, circleC5, circleC6, circleC7;
        private float[] roundC0, roundC1, roundC2, roundC3, roundC4, roundC5, roundC6, roundC7;
        private float[] tempC0, tempC1, tempC2, tempC3, tempC4, tempC5, tempC6, tempC7;

        public Circle(int startColor, int endColor, int startAngle, int endAngle) {
            this.path = new Path();
            this.startColor = startColor;
            this.endColor = endColor;
            this.startAngle = startAngle;
            this.endAngle = endAngle;
        }

        @Override
        protected void onBoundsChange(Rect bounds) {
            super.onBoundsChange(bounds);
            setDrawBounds(clipSquare(bounds));
            int w = getDrawBounds().width();
            int h = getDrawBounds().height();
            this.strokeWidth = ConvertUtils.dp2px(2f);
            this.margin = strokeWidth + ConvertUtils.dp2px(8f);
            setShape(new LinearGradient(0f, 0f, w, h, startColor, endColor, Shader.TileMode.CLAMP));
            p0 = new float[]{0 + margin, h / 2};
            p1 = new float[]{w / 2, 0 + margin};
            p2 = new float[]{w - margin, h / 2};
            p3 = new float[]{w / 2, h - margin};

            c0 = new float[]{0 + margin, h * 3 / 4};
            c1 = new float[]{0 + margin, h / 9};
            c2 = new float[]{w / 4, 0 + margin};
            c3 = new float[]{w * 3 / 4, 0 + margin};
            c4 = new float[]{w - margin, h / 9};
            c5 = new float[]{w - margin, h * 3 / 4};
            c6 = new float[]{w * 3 / 4, h - margin};
            c7 = new float[]{w / 8, h - margin};

            circleC0 = new float[]{0 + margin, h * 3 / 4};
            circleC1 = new float[]{0 + margin, h / 4};
            circleC2 = new float[]{w / 4, 0 + margin};
            circleC3 = new float[]{w * 3 / 4, 0 + margin};
            circleC4 = new float[]{w - margin, h / 4};
            circleC5 = new float[]{w - margin, h * 3 / 4};
            circleC6 = new float[]{w * 3 / 4, h - margin};
            circleC7 = new float[]{w / 4, h - margin};

            roundC0 = new float[]{0 + margin, h * 3 / 4};
            roundC1 = new float[]{0 + margin, h / 9};
            roundC2 = new float[]{w / 4, 0 + margin};
            roundC3 = new float[]{w * 3 / 4, 0 + margin};
            roundC4 = new float[]{w - margin, h / 9};
            roundC5 = new float[]{w - margin, h * 3 / 4};
            roundC6 = new float[]{w * 3 / 4, h - margin};
            roundC7 = new float[]{w / 8, h - margin};

            if (dancing.get() == true) {
                stashTemp();
                changeShape(1, false);
            } else {
                stashTemp();
                changeShape(1, true);
            }
        }

        private void stashTemp() {
            if (!isDrawableInit()) {
                Logger.INSTANCE.e(TAG, "cannot stash temp, drawable did not init");
                return;
            }
            tempC0 = new float[]{c0[0], c0[1]};
            tempC1 = new float[]{c1[0], c1[1]};
            tempC2 = new float[]{c2[0], c2[1]};
            tempC3 = new float[]{c3[0], c3[1]};
            tempC4 = new float[]{c4[0], c4[1]};
            tempC5 = new float[]{c5[0], c5[1]};
            tempC6 = new float[]{c6[0], c6[1]};
            tempC7 = new float[]{c7[0], c7[1]};
        }

        public boolean isDrawableInit() {
            Rect drawBounds = getDrawBounds();
            return drawBounds != null && (drawBounds.left != 0 || drawBounds.top != 0 || drawBounds.right != 0 || drawBounds.bottom != 0);
        }

        public void changeShape(float value, boolean circle) {
            if (!isDrawableInit()) {
                Logger.INSTANCE.e(TAG, "cannot change shape, drawable did not init");
                return;
            }
            if (circle) {
                c0[0] = tempC0[0] + (circleC0[0] - tempC0[0]) * value;
                c0[1] = tempC0[1] + (circleC0[1] - tempC0[1]) * value;
                c1[0] = tempC1[0] + (circleC1[0] - tempC1[0]) * value;
                c1[1] = tempC1[1] + (circleC1[1] - tempC1[1]) * value;
                c2[0] = tempC2[0] + (circleC2[0] - tempC2[0]) * value;
                c2[1] = tempC2[1] + (circleC2[1] - tempC2[1]) * value;
                c3[0] = tempC3[0] + (circleC3[0] - tempC3[0]) * value;
                c3[1] = tempC3[1] + (circleC3[1] - tempC3[1]) * value;
                c4[0] = tempC4[0] + (circleC4[0] - tempC4[0]) * value;
                c4[1] = tempC4[1] + (circleC4[1] - tempC4[1]) * value;
                c5[0] = tempC5[0] + (circleC5[0] - tempC5[0]) * value;
                c5[1] = tempC5[1] + (circleC5[1] - tempC5[1]) * value;
                c6[0] = tempC6[0] + (circleC6[0] - tempC6[0]) * value;
                c6[1] = tempC6[1] + (circleC6[1] - tempC6[1]) * value;
                c7[0] = tempC7[0] + (circleC7[0] - tempC7[0]) * value;
                c7[1] = tempC7[1] + (circleC7[1] - tempC7[1]) * value;
            } else {
                c0[0] = tempC0[0] + (roundC0[0] - tempC0[0]) * value;
                c0[1] = tempC0[1] + (roundC0[1] - tempC0[1]) * value;
                c1[0] = tempC1[0] + (roundC1[0] - tempC1[0]) * value;
                c1[1] = tempC1[1] + (roundC1[1] - tempC1[1]) * value;
                c2[0] = tempC2[0] + (roundC2[0] - tempC2[0]) * value;
                c2[1] = tempC2[1] + (roundC2[1] - tempC2[1]) * value;
                c3[0] = tempC3[0] + (roundC3[0] - tempC3[0]) * value;
                c3[1] = tempC3[1] + (roundC3[1] - tempC3[1]) * value;
                c4[0] = tempC4[0] + (roundC4[0] - tempC4[0]) * value;
                c4[1] = tempC4[1] + (roundC4[1] - tempC4[1]) * value;
                c5[0] = tempC5[0] + (roundC5[0] - tempC5[0]) * value;
                c5[1] = tempC5[1] + (roundC5[1] - tempC5[1]) * value;
                c6[0] = tempC6[0] + (roundC6[0] - tempC6[0]) * value;
                c6[1] = tempC6[1] + (roundC6[1] - tempC6[1]) * value;
                c7[0] = tempC7[0] + (roundC7[0] - tempC7[0]) * value;
                c7[1] = tempC7[1] + (roundC7[1] - tempC7[1]) * value;
            }

            path.reset();
            path.moveTo(p0[0], p0[1]);
            cubicTo(path, c1, c2, p1);
            cubicTo(path, c3, c4, p2);
            cubicTo(path, c5, c6, p3);
            cubicTo(path, c7, c0, p0);
            invalidateSelf();
        }

        @Override
        public void drawShape(Canvas canvas, Paint paint) {
            paint.setStrokeWidth(strokeWidth);
            paint.setStyle(Paint.Style.STROKE);
            canvas.translate(getDrawBounds().left, getDrawBounds().top);
            canvas.drawPath(path, paint);
        }

        private void cubicTo(Path path, float[] c0, float[] c1, float[] p) {
            path.cubicTo(
                    c0[0], c0[1],
                    c1[0], c1[1],
                    p[0], p[1]
            );
        }

        @Override
        public ValueAnimator onCreateAnimation() {
            float[] fractions = new float[]{0, 1};
            return new SpriteAnimatorBuilder(this).
                    rotate(fractions, startAngle, endAngle).
                    duration(5500).
                    build();
        }
    }

    private ValueAnimator.AnimatorUpdateListener stopAnimUpdateListener = animation -> {
        float value = (float) animation.getAnimatedValue();
        for (int i = 0; i < getChildCount(); i++) {
            Sprite child = getChildAt(i);
            if (child instanceof Circle) {
                Circle circle = (Circle) child;
                circle.changeShape(value, true);
            }
        }
    };
    private Animator.AnimatorListener stopAnimListener = new Animator.AnimatorListener() {
        @Override
        public void onAnimationStart(Animator animation) {

        }

        @Override
        public void onAnimationEnd(Animator animation) {
            stop();
        }

        @Override
        public void onAnimationCancel(Animator animation) {

        }

        @Override
        public void onAnimationRepeat(Animator animation) {

        }
    };


    public void stopDance() {
        if (dancing.compareAndSet(true, false)) {
            Logger.INSTANCE.i(TAG, "stop dance");
            for (int i = 0; i < getChildCount(); i++) {
                Sprite child = getChildAt(i);
                if (child instanceof Circle) {
                    Circle circle = (Circle) child;
                    if (!circle.isDrawableInit()) {
                        Logger.INSTANCE.e(TAG, "cannot stop dance, drawable did not init");
                        return;
                    }
                    circle.stashTemp();
                }
            }
            valueAnimator.removeAllUpdateListeners();
            valueAnimator.removeAllListeners();
            valueAnimator.addUpdateListener(stopAnimUpdateListener);
            valueAnimator.addListener(stopAnimListener);
            valueAnimator.start();
        }
    }

    private ValueAnimator.AnimatorUpdateListener startAnimUpdateListener = animation -> {
        float value = (float) animation.getAnimatedValue();
        for (int i = 0; i < getChildCount(); i++) {
            Sprite child = getChildAt(i);
            if (child instanceof Circle) {
                Circle circle = (Circle) child;
                circle.changeShape(value, false);
            }
        }
    };
    private Animator.AnimatorListener startAnimListener = new Animator.AnimatorListener() {
        @Override
        public void onAnimationStart(Animator animation) {
            start();
        }

        @Override
        public void onAnimationEnd(Animator animation) {

        }

        @Override
        public void onAnimationCancel(Animator animation) {

        }

        @Override
        public void onAnimationRepeat(Animator animation) {

        }
    };

    public void startDance() {
        if (dancing.compareAndSet(false, true)) {
            Logger.INSTANCE.i(TAG, "start dance");
            for (int i = 0; i < getChildCount(); i++) {
                Sprite child = getChildAt(i);
                if (child instanceof Circle) {
                    Circle circle = (Circle) child;
                    if (!circle.isDrawableInit()) {
                        Logger.INSTANCE.e(TAG, "cannot start dance, drawable did not init");
                        return;
                    }
                    circle.stashTemp();
                }
            }
            valueAnimator.removeAllUpdateListeners();
            valueAnimator.removeAllListeners();
            valueAnimator.addUpdateListener(startAnimUpdateListener);
            valueAnimator.addListener(startAnimListener);
            valueAnimator.start();
        }
    }
}
