package io.agora.avc.widget.drawable

import android.animation.ValueAnimator
import android.graphics.*
import android.graphics.drawable.Drawable
import androidx.annotation.ColorInt

class DialingDrawable(val width: Int, val height: Int, @ColorInt _color: Int) : Drawable() {

    private var circleSpacing = CIRCLE_SPACING

    private var radius = 0f
    private var animators: ArrayList<ValueAnimator>? = null

    private val scaleFloats = arrayOf(
        SCALE,
        SCALE,
        SCALE,
    )

    private val alphas = arrayOf(
        ALPHA,
        ALPHA,
        ALPHA,
    )

    private val paint = Paint(Paint.ANTI_ALIAS_FLAG).apply {
        color = _color
        style = Paint.Style.FILL
    }

    private var x = 0f
    private var y = 0f

    override fun draw(canvas: Canvas) {
        for (i in 0 until POINT_COUNT) {
            canvas.save()
            val translateX = x + (radius * 2 + circleSpacing) * i
            canvas.translate(translateX, y)
            canvas.scale(scaleFloats[i], scaleFloats[i])
            paint.alpha = alphas[i]
            canvas.drawCircle(0f, 0f, radius, paint)
            canvas.restore()
        }
    }

    fun startAnimator() {
        val delays = arrayOf(0L, 100L, 200L)
        if (animators == null) {
            animators = arrayListOf()
        }
        animators?.clear()
        for (i in 0 until POINT_COUNT) {
            animators!!.add(ValueAnimator.ofFloat(1f, 0.75f, 1f).apply {
                duration = DURATION
                repeatCount = -1
                startDelay = delays[i]
                addUpdateListener {
                    scaleFloats[i] = it.animatedValue as Float
                    invalidateSelf()
                }
                start()
            })
            animators!!.add(ValueAnimator.ofInt(255, 51, 255).apply {
                duration = DURATION
                repeatCount = -1
                startDelay = delays[i]
                addUpdateListener {
                    alphas[i] = it.animatedValue as Int
                    invalidateSelf()
                }
                start()
            })
        }
    }

    fun stopAnimator() {
        animators?.forEach {
            it.cancel()
        }
        animators?.clear()
    }

    fun isRunning() = animators != null && animators!!.isNotEmpty()


    override fun onBoundsChange(bounds: Rect?) {
        bounds?.let {
            radius = (bounds.width() - circleSpacing * (POINT_COUNT - 1f)) / (POINT_COUNT * 2f)
            x = bounds.width() / 2f - (radius * 2f + circleSpacing)
            y = bounds.height() / 2f
        }
    }

    override fun getIntrinsicWidth(): Int {
        return width
    }

    override fun getIntrinsicHeight(): Int {
        return height
    }

    override fun setAlpha(alpha: Int) {

    }

    override fun setColorFilter(colorFilter: ColorFilter?) {

    }

    override fun getOpacity() = PixelFormat.TRANSPARENT

    companion object {
        const val CIRCLE_SPACING = 8
        const val SCALE = 1f
        const val ALPHA = 255
        const val POINT_COUNT = 3
        const val DURATION = 700L
    }
}