package io.agora.avc.widget.pop

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import androidx.appcompat.content.res.AppCompatResources
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.view.isVisible
import androidx.recyclerview.widget.DividerItemDecoration
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import io.agora.avc.R
import io.agora.avc.bo.MeetingNotification
import io.agora.avc.databinding.LayoutNotificationPopBinding
import io.agora.avc.widget.helper.SlideRemoveHelper
import io.agora.avc.widget.recyclerviewanimators.SlideInRightAnimationAdapter
import io.agora.avc.widget.recyclerviewanimators.SlideInRightAnimator
import io.agora.logger.Logger

class NotificationPop @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0
) : ConstraintLayout(context, attrs, defStyleAttr) {

    private val binding =
        LayoutNotificationPopBinding.inflate(LayoutInflater.from(context), this, true)

    private val adapter = NotificationPopAdapter()

    init {
        binding.rvNotificationPop.layoutManager =
            object : LinearLayoutManager(context, VERTICAL, false) {
                override fun canScrollVertically(): Boolean {
                    return true
                }
            }
        binding.rvNotificationPop.adapter = SlideInRightAnimationAdapter(adapter)
        SlideRemoveHelper(adapter).attachToRecyclerView(binding.rvNotificationPop)
        binding.rvNotificationPop.addItemDecoration(
            DividerItemDecoration(
                context,
                DividerItemDecoration.VERTICAL
            ).also { decoration ->
                AppCompatResources.getDrawable(context, R.drawable.shape_pop_divider)?.let {
                    decoration.setDrawable(it)
                }
            })
        binding.rvNotificationPop.itemAnimator = object : SlideInRightAnimator() {
            override fun onAddStarting(item: RecyclerView.ViewHolder?) {
                isVisible = adapter.itemCount > 0
            }

            override fun onRemoveFinished(item: RecyclerView.ViewHolder?) {
                isVisible = adapter.itemCount > 0
            }
        }
    }

    fun setOnClickListener(onClickListener: ((v: View, item: MeetingNotification, position: Int) -> Unit)) {
        adapter.onClickListener = onClickListener
    }

    fun setOnItemSwipedDismissListener(onItemSwipedDismissListener: ((item: MeetingNotification, position:Int) -> Unit)) {
        adapter.onItemSwipedDismissListener = onItemSwipedDismissListener
    }

    fun submitList(list: List<MeetingNotification>) {
        Logger.i(TAG, "submit list, list size:${list.size}")
        if (list.isNotEmpty()) {
            isVisible = true
        }
        adapter.submitList(list)
    }

    companion object {
        const val TAG = "[UI][NotificationPop]"
    }
}