package io.agora.avc.widget.pop

import android.view.View
import androidx.core.view.isVisible
import androidx.recyclerview.widget.RecyclerView
import io.agora.avc.R
import io.agora.avc.bo.MeetingNotification
import io.agora.avc.databinding.ItemNotificationPopAcBinding
import io.agora.avc.manager.notice.NoticeType
import io.agora.avc.utils.SpanUtils
import io.agora.avc.utils.StringUtils
import io.agora.avc.utils.ThemeUtils

class NotificationPopACViewHolder(val binding: ItemNotificationPopAcBinding) :
    RecyclerView.ViewHolder(binding.root) {

    private var onClickListener: View.OnClickListener? = null

    fun onBind(item: MeetingNotification) {
        if (!StringUtils.isEmpty(item.content)) {
            SpanUtils.with(binding.tvMessage)
                .append(item.title)
                .appendLine()
                .append(item.content!!).apply {
                    if (item.contentIsLink) {
                        setClickSpan(
                            ThemeUtils.getAttrValue(itemView.context, R.attr.colorPrimary),
                            false
                        ) {
                            onClickListener?.onClick(it)
                        }
                    }
                }
                .create()
        } else {
            binding.tvMessage.text = item.title
        }
        binding.ivClose.isVisible = item.noticeType == NoticeType.NOTIFICATION_A
        binding.ivIcon.isVisible = item.noticeType == NoticeType.NOTIFICATION_A
    }

    fun setOnClickListener(onClickListener: View.OnClickListener) {
        this.onClickListener = onClickListener
        binding.ivClose.setOnClickListener(onClickListener)
    }
}