package io.agora.avc.widget.pop

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.ListAdapter
import androidx.recyclerview.widget.RecyclerView
import io.agora.avc.R
import io.agora.avc.bo.MeetingNotification
import io.agora.avc.databinding.ItemNotificationPopAcBinding
import io.agora.avc.databinding.ItemNotificationPopBBinding
import io.agora.avc.listener.AntiShakeClickListener
import io.agora.avc.manager.notice.NoticeType
import io.agora.avc.widget.helper.ItemTouchHelperAdapter

class NotificationPopAdapter :
    ListAdapter<MeetingNotification, RecyclerView.ViewHolder>(object :
        DiffUtil.ItemCallback<MeetingNotification>() {
        override fun areItemsTheSame(
            oldItem: MeetingNotification,
            newItem: MeetingNotification
        ): Boolean {
            return oldItem.code.stringsId == newItem.code.stringsId &&
                    oldItem.noticeType == newItem.noticeType &&
                    oldItem.notificationType == newItem.notificationType
        }

        override fun areContentsTheSame(
            oldItem: MeetingNotification,
            newItem: MeetingNotification
        ): Boolean {
            return true
        }
    }), ItemTouchHelperAdapter {

    var onClickListener: ((v: View, item: MeetingNotification, position: Int) -> Unit)? = null
    var onItemSwipedDismissListener: ((item: MeetingNotification, position:Int) -> Unit)? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return when (viewType) {
            NoticeType.NOTIFICATION_B -> {
                NotificationPopBViewHolder(
                    ItemNotificationPopBBinding.inflate(
                        LayoutInflater.from(parent.context),
                        parent,
                        false
                    )
                )
            }
            else -> {
                NotificationPopACViewHolder(
                    ItemNotificationPopAcBinding.inflate(
                        LayoutInflater.from(parent.context),
                        parent,
                        false
                    )
                )
            }
        }
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        if (holder is NotificationPopACViewHolder) {
            holder.onBind(getItem(position))
            holder.setOnClickListener(object : AntiShakeClickListener() {
                override fun onAntiShakeClicked(view: View?) {
                    val positionTemp = holder.adapterPosition
                    if (positionTemp != RecyclerView.NO_POSITION) {
                        when (view?.id) {
                            R.id.ivClose,
                            R.id.tvMessage -> {
                                onClickListener?.invoke(view, getItem(positionTemp), positionTemp)
                            }
                        }
                    }
                }
            })
        } else if (holder is NotificationPopBViewHolder) {
            holder.onBind(getItem(position))
            holder.setOnClickListener { it, item ->
                val positionTemp = holder.adapterPosition
                if (positionTemp != RecyclerView.NO_POSITION) {
                    when (it.id) {
                        R.id.btnPositive,
                        R.id.btnNegative -> {
                            onClickListener?.invoke(it, item, positionTemp)
                        }
                    }
                }
            }
        }
    }

    override fun onDetachedFromRecyclerView(recyclerView: RecyclerView) {
        super.onDetachedFromRecyclerView(recyclerView)
        onClickListener = null
        onItemSwipedDismissListener = null
    }

    override fun getItemViewType(position: Int): Int {
        return getItem(position).noticeType
    }

    override fun onItemMove(fromPosition: Int, toPosition: Int) {

    }

    override fun onItemDismiss(position: Int) {
        onItemSwipedDismissListener?.invoke(getItem(position), position)
    }
}

