package io.agora.avc.widget.pop

import android.view.View
import androidx.recyclerview.widget.RecyclerView
import io.agora.avc.R
import io.agora.avc.bo.MeetingNotification
import io.agora.avc.bo.NoticeCode
import io.agora.avc.databinding.ItemNotificationPopBBinding
import io.agora.avc.listener.AntiShakeClickListener

class NotificationPopBViewHolder(val binding: ItemNotificationPopBBinding) :
    RecyclerView.ViewHolder(binding.root) {

    private var onItemClickListener: ((v: View, item: MeetingNotification) -> Unit)? = null

    fun onBind(item: MeetingNotification) {
        binding.tvMessage.text = item.title

        setButtonText(item.code)

        itemView.setOnClickListener(object : AntiShakeClickListener() {
            override fun onAntiShakeClicked(view: View?) {
                view?.let {
                    onItemClickListener?.invoke(it, item)
                }
            }
        })
        binding.btnPositive.setOnClickListener(object : AntiShakeClickListener() {
            override fun onAntiShakeClicked(view: View?) {
                view?.let {
                    onItemClickListener?.invoke(it, item)
                }
            }
        })
        binding.btnNegative.setOnClickListener(object : AntiShakeClickListener() {
            override fun onAntiShakeClicked(view: View?) {
                view?.let {
                    onItemClickListener?.invoke(it, item)
                }
            }
        })
    }

    fun setOnClickListener(onItemClickListener: ((v: View, item: MeetingNotification) -> Unit)?) {
        this.onItemClickListener = onItemClickListener
    }

    fun setButtonText(code: NoticeCode) {
        when (code) {
            NoticeCode.CODE_AS_ROOM_ASK_HOST_EN,
            NoticeCode.CODE_AS_ROOM_ASK_HOST_CN,
            NoticeCode.CODE_AS_OPEN_TITLE_EN,
            NoticeCode.CODE_AS_OPEN_TITLE_CN,
            NoticeCode.CODE_ROOM_RTM_DISCONNECTED_PREVIEW,
            -> {
                binding.btnPositive.setText(R.string.yes_button)
                binding.btnNegative.setText(R.string.no_button)
            }
            NoticeCode.CODE_PEER_INVITE_CAMERA_RECEIVE,
            NoticeCode.CODE_PEER_INVITE_MICROPHONE_RECEIVE,
            -> {
                binding.btnPositive.setText(R.string.pop_confirm_open)
                binding.btnNegative.setText(R.string.pop_cancel_refuse)
            }
        }
    }
}