package io.agora.avc.widget.pop

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.animation.Animation
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.content.ContextCompat
import androidx.core.view.isVisible
import androidx.recyclerview.widget.DividerItemDecoration
import androidx.recyclerview.widget.LinearLayoutManager
import io.agora.avc.R
import io.agora.avc.bo.MeetingStatus
import io.agora.avc.databinding.LayoutStatusPopBinding
import io.agora.avc.widget.recyclerviewanimators.SlideInLeftAnimationAdapter
import io.agora.avc.widget.recyclerviewanimators.SlideInLeftAnimator

class StatusPop @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0
) : ConstraintLayout(context, attrs, defStyleAttr) {

    private val binding by lazy {
        LayoutStatusPopBinding.inflate(LayoutInflater.from(context), this, true)
    }

    private val adapter by lazy {
        StatusPopAdapter()
    }

    init {
        binding.rvStatusPop.layoutManager =
            object : LinearLayoutManager(context, VERTICAL, false) {
                override fun canScrollVertically(): Boolean {
                    return false
                }
            }
        binding.rvStatusPop.adapter = SlideInLeftAnimationAdapter(adapter)
        binding.rvStatusPop.addItemDecoration(
            DividerItemDecoration(
                context,
                DividerItemDecoration.VERTICAL
            ).also { decoration ->
                ContextCompat.getDrawable(context, R.drawable.shape_pop_divider)?.let {
                    decoration.setDrawable(it)
                }
            })
        binding.rvStatusPop.itemAnimator = SlideInLeftAnimator().apply {
            addDuration = 500
            removeDuration = 500
            changeDuration = 300
            moveDuration = 300
            layoutAnimationListener = object: Animation.AnimationListener{
                override fun onAnimationStart(animation: Animation?) {

                }

                override fun onAnimationEnd(animation: Animation?) {
                    isVisible = adapter.itemCount > 0
                }

                override fun onAnimationRepeat(animation: Animation?) {

                }

            }
        }
    }

    fun showStatus(meetingStatus: MeetingStatus) {
        isVisible = true
        val newList = mutableListOf<MeetingStatus>()
        if (adapter.itemCount == 0) {
            newList.add(meetingStatus)
        } else {
            var hasTheSameType = false
            adapter.currentList.forEachIndexed { _, item ->
                if (item.itemType == meetingStatus.itemType) {
                    newList.add(meetingStatus)
                    hasTheSameType = true
                } else {
                    newList.add(item)
                }
            }
            if (!hasTheSameType) {
                newList.add(meetingStatus)
            }
        }
        submitList(newList)
    }

    fun removeStatus(itemType: Int) {
        val newList = mutableListOf<MeetingStatus>()
        adapter.currentList.forEach {
            if (it.itemType != itemType) {
                newList.add(it)
            }
        }
        submitList(newList)
//        postDelayed({
//            isVisible = newList.isNotEmpty()
//        }, 500)
    }

    fun updateDuration(duration: String) {
        var cloudRecordingPosition = 0
        adapter.currentList.forEachIndexed { _index, item ->
            if (item.itemType == MeetingStatus.ITEM_TYPE_CLOUD_RECORDING) {
                cloudRecordingPosition = _index
            }
        }
        binding.rvStatusPop.findViewHolderForAdapterPosition(cloudRecordingPosition).apply {
            if (this is StatusPopViewHolder) {
                updateDuration(duration)
            }
        }
    }

    private fun submitList(newList: MutableList<MeetingStatus>) {
        adapter.submitList(newList)
    }
}