package io.agora.avc.widget.pop

import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.ListAdapter
import io.agora.avc.R
import io.agora.avc.bo.MeetingStatus

class StatusPopAdapter :
    ListAdapter<MeetingStatus, StatusPopViewHolder>(object :
        DiffUtil.ItemCallback<MeetingStatus>() {
        override fun areItemsTheSame(
            oldItem: MeetingStatus,
            newItem: MeetingStatus
        ): Boolean {
            return oldItem == newItem
        }

        override fun areContentsTheSame(
            oldItem: MeetingStatus,
            newItem: MeetingStatus
        ): Boolean {
            return oldItem == newItem
        }
    }) {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): StatusPopViewHolder {
        return StatusPopViewHolder(
            LayoutInflater.from(parent.context)
                .inflate(R.layout.item_status_pop, parent, false)
        )
    }

    override fun onBindViewHolder(holder: StatusPopViewHolder, position: Int) {
        holder.onBind(getItem(position))
    }

    override fun getItemViewType(position: Int): Int {
        return getItem(position).itemType
    }


}

