package io.agora.avc.app.address

import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.RecyclerView
import io.agora.avc.R
import io.agora.avc.app.attendees.EmptyViewHolder
import io.agora.frame.base.BaseRecyclerAdapter

class AddressBookAdapter(private val addressBookListener: AddressBookListener? = null) :
    BaseRecyclerAdapter<AddressBookNode, RecyclerView.ViewHolder>() {
    override fun convert(
        holder: RecyclerView.ViewHolder,
        items: MutableList<AddressBookNode>?,
        position: Int
    ) {
        when (holder) {
            is MemberViewHolder -> {
                holder.bindTo(data[position])
                holder.binding.checkbox.setOnClickListener {
                    addressBookListener?.onItemClicked(data[position], position)
                }
            }
            is GroupViewHolder -> {
                holder.bindTo(data[position])
                holder.binding.checkbox.setOnClickListener {
                    addressBookListener?.onToggleGroup(data[position], position)
                }
            }
            is MyGroupViewHolder -> {
                holder.bindTo(data[position])
                holder.binding.checkbox.setOnClickListener {
                    addressBookListener?.onToggleGroup(data[position], position)
                }
            }
            is EmptyViewHolder -> {

            }
            is EmptyMemberViewHolder -> {

            }
            is ErrorViewHolder -> {
                holder.binding.btnConfirm.setOnClickListener {
                    addressBookListener?.onRefreshClicked()
                }
            }
            is EmptyGroupViewHolder -> {
                holder.binding.btnConfirm.setOnClickListener {
                    addressBookListener?.onCreateGroupClicked()
                }
            }
            else -> {
                if (holder is UnknownViewHolder) {

                }
            }
        }
        holder.itemView.setOnLongClickListener {
            addressBookListener?.onLongClicked(data[position], position)
            true
        }
        holder.itemView.setOnClickListener {
            addressBookListener?.onItemClicked(data[position], position)
        }
    }

    override fun bindViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return when (viewType) {
            R.layout.avc_item_address_book_member -> {
                MemberViewHolder(
                    DataBindingUtil.inflate(
                        LayoutInflater.from(parent.context),
                        R.layout.avc_item_address_book_member,
                        parent,
                        false
                    )
                )
            }
            R.layout.avc_item_address_book_group -> {
                GroupViewHolder(
                    DataBindingUtil.inflate(
                        LayoutInflater.from(parent.context),
                        R.layout.avc_item_address_book_group,
                        parent,
                        false
                    )
                )
            }
            R.layout.avc_item_empty_view -> {
                EmptyViewHolder(
                    DataBindingUtil.inflate(
                        LayoutInflater.from(parent.context),
                        R.layout.avc_item_empty_view,
                        parent,
                        false
                    )
                )
            }
            R.layout.avc_item_error_view -> {
                ErrorViewHolder(
                    DataBindingUtil.inflate(
                        LayoutInflater.from(parent.context),
                        R.layout.avc_item_error_view,
                        parent,
                        false
                    )
                )
            }
            R.layout.avc_item_my_group -> {
                MyGroupViewHolder(
                    DataBindingUtil.inflate(
                        LayoutInflater.from(parent.context),
                        R.layout.avc_item_my_group,
                        parent,
                        false
                    )
                )
            }
            R.layout.avc_item_empty_group_view -> {
                EmptyGroupViewHolder(
                    DataBindingUtil.inflate(
                        LayoutInflater.from(parent.context),
                        R.layout.avc_item_empty_group_view,
                        parent,
                        false
                    )
                )
            }
            R.layout.avc_item_empty_member_view -> {
                EmptyMemberViewHolder(
                    DataBindingUtil.inflate(
                        LayoutInflater.from(parent.context),
                        R.layout.avc_item_empty_member_view,
                        parent,
                        false
                    )
                )
            }
            else -> {
                UnknownViewHolder(
                    DataBindingUtil.inflate(
                        LayoutInflater.from(parent.context),
                        R.layout.avc_item_address_book_unknown,
                        parent,
                        false
                    )
                )
            }
        }
    }

    override fun getItemViewType(position: Int): Int {
        return data[position].viewType
    }
}