package io.agora.avc.app.address

import android.content.res.Configuration
import android.os.Bundle
import android.view.Gravity
import android.widget.FrameLayout
import androidx.appcompat.app.AlertDialog
import androidx.core.os.bundleOf
import androidx.fragment.app.Fragment
import androidx.navigation.Navigation
import androidx.navigation.fragment.findNavController
import com.google.android.material.bottomsheet.BottomSheetBehavior
import com.google.android.material.dialog.MaterialAlertDialogBuilder
import io.agora.avc.R
import io.agora.avc.app.group.KEY_GROUP_ID
import io.agora.avc.app.group.KEY_GROUP_NAME
import io.agora.avc.databinding.AvcFragmentGroupOperationBinding
import io.agora.avc.extensions.safeNavigate
import io.agora.avc.utils.ScreenUtils
import io.agora.avc.utils.StringUtils
import io.agora.frame.base.BaseSheetDialogFragment

class GroupOperationFragment :
    BaseSheetDialogFragment<GroupOperationViewModel, AvcFragmentGroupOperationBinding>() {

    private var confirmDialingDialog: AlertDialog? = null

    private lateinit var groupId: String
    private var groupName: String? = null

    override fun getLayoutId() = R.layout.avc_fragment_group_operation

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.getString(KEY_GROUP_ID).let {
            if (StringUtils.isEmpty(it)) {
                findNavController().navigateUp()
            } else {
                this.groupId = it!!
            }
        }
        groupName = arguments?.getString(KEY_GROUP_NAME)
    }

    override fun initialize(savedInstanceState: Bundle?) {

        mBinding.tvTitle.text =
            arguments?.getString(KEY_GROUP_NAME) ?: StringUtils.getString(R.string.avc_unknown_user)

        mBinding.llDel.setOnClickListener {
            if (confirmDialingDialog?.isShowing == true) {
                return@setOnClickListener
            }
            context?.let {
                confirmDialingDialog =
                    MaterialAlertDialogBuilder(it, R.style.avc_CustomMaterialAlertDialog)
                        .setTitle(StringUtils.getString(R.string.avc_group_delete_confirm))
                        .setCancelable(false)
                        .setNegativeButton(R.string.avc_cancel) { _, _ -> }
                        .setPositiveButton(R.string.avc_confirm) { _, _ ->
                            mViewModel.deleteGroup(groupId)
                            onBackPressed()
                        }
                        .show()
            }
        }

        mBinding.llEdit.setOnClickListener {
            safeNavigate(
                R.id.action_group_operation_to_group_tailored,
                bundleOf(
                    KEY_GROUP_ID to groupId,
                    KEY_GROUP_NAME to groupName
                )
            )
        }
    }

    override fun allocObserver() {
        mViewModel.exitEvent.observe(this) {
            onBackPressed()
        }
    }

    override fun onStart() {
        super.onStart()
        mDialog.setCanceledOnTouchOutside(true)
        onConfigurationChanged(resources.configuration)
    }

    override fun onConfigurationChanged(newConfig: Configuration) {
        super.onConfigurationChanged(newConfig)
        if (newConfig.orientation == Configuration.ORIENTATION_LANDSCAPE) {
            switch2Landscape()
        } else {
            switch2Portrait()
        }
    }

    private fun switch2Portrait() {
        val layoutParams = mBinding.container.layoutParams as FrameLayout.LayoutParams
        layoutParams.width = ScreenUtils.getScreenWidth()
        layoutParams.gravity = Gravity.START
        mBinding.container.layoutParams = layoutParams
        mBehavior?.skipCollapsed = true
        mBehavior?.state = BottomSheetBehavior.STATE_EXPANDED
    }

    private fun switch2Landscape() {
        val layoutParams = mBinding.container.layoutParams as FrameLayout.LayoutParams
        layoutParams.width = ScreenUtils.getScreenWidth() / 2
        layoutParams.gravity = Gravity.END
        mBinding.container.layoutParams = layoutParams
        mBehavior?.skipCollapsed = true
        mBehavior?.state = BottomSheetBehavior.STATE_EXPANDED
    }

    companion object {
        private const val TAG = "[UI][InvitingOperation]"
        fun navigateTo(
            fragment: Fragment,
            groupId: String,
            groupName: String,
        ) {
            fragment.activity?.let {
                Navigation.findNavController(it, R.id.nav_fragment).navigate(
                    R.id.groupOperation,
                    bundleOf(
                        KEY_GROUP_ID to groupId,
                        KEY_GROUP_NAME to groupName,
                    )
                )
            }
        }
    }
}