package io.agora.avc.app.address

import android.app.Application
import com.agora.valoran.bean.SimpleRoomUser
import com.google.gson.JsonSyntaxException
import io.agora.avc.app.group.MeetupResponse
import io.agora.avc.base.AppViewModel
import io.agora.avc.biz.AppController
import io.agora.avc.biz.event.AppEvent
import io.agora.avc.biz.event.MessageEvent
import io.agora.avc.bo.NoticeCode
import io.agora.avc.bo.valoran.ARoomUser
import io.agora.avc.manager.notice.NoticeEvent
import io.agora.avc.utils.GsonUtils
import io.agora.frame.base.livedata.EventLiveData
import io.agora.logger.Logger
import javax.inject.Inject

class GroupOperationViewModel @Inject constructor(
    application: Application,
    appController: AppController,
) : AppViewModel(application, appController) {

    val exitEvent = EventLiveData<Boolean>()

    private var currentSeq = -1
    private var groupId: String? = null

    fun deleteGroup(groupId: String) {
        this.groupId = groupId
        currentSeq = appController.getOperationSeqId()
        appController.deleteMeetup(currentSeq, groupId)
    }

    companion object {
        const val TAG = "[VM][InvitingOperation]"
    }
}