package io.agora.avc.app.address

import android.content.Context
import android.graphics.Rect
import android.view.View
import android.view.View.MeasureSpec.AT_MOST
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import io.agora.avc.utils.ConvertUtils

class MaxSizeLayoutManager @JvmOverloads constructor(
    context: Context?,
    @RecyclerView.Orientation orientation: Int = RecyclerView.VERTICAL,
    reverseLayout: Boolean = false,
    private var maxWidth: Float = 0f,
    private var maxHeight: Float = 0f,
) : LinearLayoutManager(context, orientation, reverseLayout) {

    override fun setMeasuredDimension(childrenBounds: Rect?, wSpec: Int, hSpec: Int) {
        val width = if (maxWidth.toInt() != 0) {
            View.MeasureSpec.makeMeasureSpec(ConvertUtils.dp2px(maxWidth), AT_MOST)
        } else {
            wSpec
        }
        val height = if (maxHeight.toInt() != 0) {
            View.MeasureSpec.makeMeasureSpec(ConvertUtils.dp2px(maxHeight), AT_MOST)
        } else {
            wSpec
        }
        super.setMeasuredDimension(childrenBounds, width, height)
    }

    fun setMaxWidth(width: Float) {
        maxWidth = width
        requestLayout()
    }

    fun setMaxHeight(height: Float) {
        maxHeight = height
        requestLayout()
    }
}