package io.agora.avc.app.address

import com.bumptech.glide.Glide
import io.agora.avc.R
import io.agora.avc.databinding.AvcItemAddressBookMemberBinding
import io.agora.avc.utils.StringUtils

class MemberViewHolder constructor(val binding: AvcItemAddressBookMemberBinding) :
    androidx.recyclerview.widget.RecyclerView.ViewHolder(binding.root) {

    fun bindTo(data: AddressBookNode?) {
        if (data is MemberNode) {
            binding.checkbox.isEnabled = !data.isJoined
            binding.checkbox.isChecked = data.isChecked
            if (StringUtils.isEmpty(data.alias)) {
                binding.tvName.text = "${data.name}"
            } else {
                binding.tvName.text = "${data.name}(${data.alias})"
            }
            Glide.with(binding.root.context)
                .load(data.avatar)
                .centerCrop()
                .placeholder(R.drawable.avc_ic_head_portrait2)
                .into(binding.ivPhoto)
        }
    }

}